#region References

using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using BLOODUNIT = gov.va.med.vbecs.Common.VbecsTables.BloodUnit;
using System.Windows.Forms;

#endregion

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/30/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///UI dialog allowing users to select a single unit for blood unit modification
	///</summary>
	public class DlgSelectSingleUnit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private BOL.BloodUnitModification _bumControl;
		private bool _needsRefresh = false;

		#endregion

		#region Form Controls

		/// <summary>
		/// BloodUnitSelector object
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.BloodUnitSelector bloodUnitSelector1;

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Destructors

		/// <summary>
		/// Constructor for selecting a single unit to modify
		/// </summary>
		/// <remarks>Indy</remarks>
		public DlgSelectSingleUnit(BOL.BloodUnitModification bumControl)
		{
			this._bumControl = bumControl;
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			if (this._bumControl.IsPool)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgSelectSingleUnit());
			}
			else if (this._bumControl.IsSplit)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgSelectSingleUnit());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgSelectSingleUnit());
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectSingleUnit));
			this.bloodUnitSelector1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelector(this.components);
			this.btnCancel = new System.Windows.Forms.Button();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(574, 30);
			this.vbecsLogo1.Title = "Select Unit";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 282);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// bloodUnitSelector1
			// 
			this.bloodUnitSelector1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus;
			this.bloodUnitSelector1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.bloodUnitSelector1.BloodUnit = null;
			this.bloodUnitSelector1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelector1.Location = new System.Drawing.Point(4, 36);
			this.bloodUnitSelector1.Name = "bloodUnitSelector1";
			this.bloodUnitSelector1.RecursionGuard = false;
			this.bloodUnitSelector1.Size = new System.Drawing.Size(566, 256);
			this.bloodUnitSelector1.TabIndex = 0;
			this.bloodUnitSelector1.UnitTable = null;
			this.bloodUnitSelector1.SelectBtnClick += new gov.va.med.vbecs.GUI.controls.BloodUnitSelector.SelectBtnClickedEventHandler(this.bloodUnitSelector1_SelectBtnClick);
			this.bloodUnitSelector1.SearchClick += new System.EventHandler(this.bloodUnitSelector1_SearchClick);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(232, 266);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 1;
			this.btnCancel.Text = "&Cancel";
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// DlgSelectSingleUnit
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(574, 298);
			this.KeyDownSpeakMessage +=new KeyDownSpeakMessageEventHandler(DlgSelectSingleUnit_KeyDownSpeakMessage); // **** 508 Compliance ***
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.bloodUnitSelector1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(580, 330);
			this.Name = "DlgSelectSingleUnit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Unit";
			this.Controls.SetChildIndex(this.bloodUnitSelector1, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Returns the selected blood unit
		/// </summary>
		/// <remarks>Indy</remarks>
		public BOL.BloodUnit BloodUnit
		{
			get
			{
				return this.bloodUnitSelector1.BloodUnit;
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		/// <remarks>Indy</remarks>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			if (this._bumControl.ProductModificationCode == Common.ProductModification.EditPool)
			{
				this.vbecsLogo1.Title = "Select a Pooled Unit";
			}
			else
			{
				this.vbecsLogo1.Title = "Select Unit";
			}
		}

		/// <summary>
		/// Throw messageboxes at the user based on Business Rule Validations
		/// Can I put this as a static method in the DlgModifyUnit class?
		/// </summary>
		private void ValidateBusinessRules()
		{
			this._needsRefresh = false;

			System.Collections.ArrayList actionList = this._bumControl.ValidateBusinessRules(this.BloodUnit, ThisUser);

			//If there's nothing in our actionList, that means the selected unit was valid, and we move on
			if (actionList.Count == 0)
				return;
			
			for (int ndx=0; ndx < actionList.Count; ndx++)
			{
				Common.ActionItem dothis = (Common.ActionItem)actionList[ndx];

				if (dothis.ReturnAction == Common.VerifyAction.Cancel)
				{
					// CR2017: Changed the MessageBox to error type to generate a beep
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(dothis.Message));
					throw new BOL.BusinessObjectException(string.Empty);
				}

				//Unit is biohazardous and an override is requried
				if (dothis.ReturnAction == Common.VerifyAction.OverrideBiohazard)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(dothis.Message)) == DialogResult.Yes)
					{	
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
						{
							DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(this.BloodUnit, dothis.Message);

							dlgExpire.ShowDialogFromLockedParent(this, false);
                            
							if (dlgExpire.DialogResult == DialogResult.OK)
							{
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Biohazardous_unit_modified, dlgExpire.Comment, Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionUnitModification(this.BloodUnit, this._bumControl, DateTime.MinValue, null);
								this._bumControl.Exceptions.Add(exRep);
							}
							else
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
								throw new BOL.BusinessObjectException(string.Empty);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				//Unit is expired and an override is required
				if (dothis.ReturnAction == Common.VerifyAction.OverrideExpiration)
				{				
					if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
					{
						DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(this.BloodUnit, dothis.Message);
                        dlgExpire.ShowDialogFromLockedParent(this, false);

						if (dlgExpire.DialogResult == DialogResult.OK)
						{
							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_unit_modified, dlgExpire.Comment, Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionUnitModification(this.BloodUnit, this._bumControl, DateTime.MinValue, null);
							this._bumControl.Exceptions.Add(exRep);
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				if (dothis.ReturnAction == Common.VerifyAction.Release)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(dothis.Message)) == DialogResult.Yes)
					{				
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
						{
							FrmDiscardQuarantine frmDQ = new FrmDiscardQuarantine(this.BloodUnit);
                            frmDQ.ShowDialogFromLockedParent(this, true);

							if (frmDQ.DialogResult == DialogResult.Cancel)
							{								
								//They've cancelled on the override, so this seems friendly enough, right?
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
								throw new BOL.BusinessObjectException(string.Empty);
							}
							else
							{
								//Double-check to make sure they didn't do something else in UC27 -- 
								BOL.BloodUnitStatus unitStatus = new BOL.BloodUnitStatus(this.BloodUnit.BloodUnitGuid);
								if (unitStatus.QuarantineIndicator)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
									throw new BOL.BusinessObjectException(string.Empty);
								}
								//Everything went ok, so we'll  need to update the unit
								this._needsRefresh = true;
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}


				if (dothis.ReturnAction == Common.VerifyAction.Warning)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(dothis.Message));
				}
			}

		}

		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Blood unit selector control select button click event handler, checks that unit
		/// is valid for selection for product modification type. System may prompt for user
		/// override on selection.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		/// <remarks>Indy</remarks>
		private void bloodUnitSelector1_SelectBtnClick(object sender, System.EventArgs e)
		{

			try
			{
				if (this.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Available ||
					this.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned ||
					this.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned ||
					this.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Limited)
				{
					//Check the unit for pending transfer status
					if (this.BloodUnit.PendingTransferIndicator)
					{
						throw new BOL.BusinessObjectException(string.Format("Unit {0}, {1} is pending transfer and cannot be selected.",this.BloodUnit.EyeReadableUnitId, this.BloodUnit.ProductType.ProductTypeText));
					}

					if (this._bumControl.ProductModificationCode == Common.ProductModification.EditPool)
					{
						DataTable dtPooled = BOL.BloodUnitModification.GetModifiableBloodUnits(this._bumControl.ProductModificationCode, this._bumControl.ModificationMethod, false);
						DataRow[] dr = dtPooled.Select("BloodUnitGuid = '" + this.BloodUnit.BloodUnitGuid.ToString() + "'");

						if (dr.Length == 0)
						{
							//We needs to throw a exception to trip up the BloodUnitSelector
							throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR36InvalidUnit(Common.Utility.GetProductModificationTextFromEnum(this._bumControl.ProductModificationCode), this.BloodUnit.EyeReadableUnitId, this.BloodUnit.ProductType.ProductTypeText).ResString);
						}

						//Edit Pool has different security levels that regular modifications
						//Validate the user access -- Enhanced Tech if no patient assignments
						if (this.BloodUnit.PatientAssignments.Rows.Count > 0)
						{
							if (!IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditBloodUnitLongitudinalRecord)) 
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
								return;
							}
						}
						else
						{
							if (!IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditVerifiedUnitConfirmationTesting)) 
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
								return;
							}
						}
					}
					else
					{
						//Find out if the bloodunit the user is requesting is valid to be modified the way they've selected
						DataTable dt = this._bumControl.GetTargetBloodProducts(this.BloodUnit.BloodProductGuid.ToString());
					
						//If nothing was found then the unit wasn't valid to modify
						if (dt.Rows.Count == 0)
						{
							//We needs to throw a exception to trip up the BloodUnitSelector
							throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR36InvalidUnit(Common.Utility.GetProductModificationTextFromEnum(this._bumControl.ProductModificationCode), this.BloodUnit.EyeReadableUnitId, this.BloodUnit.ProductType.ProductTypeText).ResString);
						}
					}
				}
				else
				{
					throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR33InvalidUnitStatus(this.BloodUnit.EyeReadableUnitId, this.BloodUnit.ProductType.ProductTypeText, this.BloodUnit.BloodUnitStatus.UnitStatusText).ResString);
				}

				this.ValidateBusinessRules();
				//The businessrules went through ok and if we made changes, refresh the unit
				if (this._needsRefresh)	this.bloodUnitSelector1.RefreshBloodUnitData();

				this.DialogResult = DialogResult.OK;
				this.Close();
			}
			catch(Exception err)
			{
				if (err.Message != string.Empty)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Blood unit selector control search button click event handler, loads unit search dialog
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		/// <remarks>Indy</remarks>
		private void bloodUnitSelector1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					DataTable eligableUnits = BOL.BloodUnitModification.GetModifiableBloodUnits(this._bumControl.ProductModificationCode, this._bumControl.ModificationMethod, false);
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligableUnits, this.bloodUnitSelector1.EnteredEyeReadableUnitId, this.bloodUnitSelector1.EnteredUnitProductCode);
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Select Unit for Modification";
					unitSelector.LogoBarText = "Select Unit for Modification";

					unitSelector.ShowDialogFromLockedParent(this,false);

					if (unitSelector.DialogResult == DialogResult.OK)
					{
						if (unitSelector.SelectedUnits.Rows.Count > 0) 
						{
							DataRow dr = unitSelector.SelectedUnits.Rows[0];
							
							//we don't need to perform the ValidateBusinessRules since it's a "single Unit" selector -- btnSelect_click will catch it

							this.bloodUnitSelector1.PopulateSelector((System.Guid)dr[BLOODUNIT.BloodUnitGuid]);
						}
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.GeneralError(err.Message));
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectSingleUnit_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;

			if ( !this.bloodUnitSelector1.SelectButtonEnabled && this.bloodUnitSelector1.BloodUnit == null )
			{
				textToSpeak = ( Common.StrRes.Tooltips.UC026.MustSelectXUnitsToContinue(1, "unit").ResString );
			}
			
			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.bloodUnitSelector1.GetErrorMessages();
			this.SpeakMessage(textToSpeak);
		}

		#endregion
	}
}

